/*
 * Decompiled with CFR 0.152.
 */
package hu.intro.unmined.metadumpmod;

import com.google.gson.stream.JsonWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.registry.FMLControlledNamespacedRegistry;
import net.minecraftforge.fml.common.registry.GameData;

@Mod(modid="MetaDump", name="MetaDump", version="1.0.1", acceptedMinecraftVersions="[1.8]")
public class MetaDumpMod {
    public static final String MOD_ID = "MetaDump";
    public static final String MOD_NAME = "MetaDump";
    public static final String MOD_VERSION = "1.0.1";
    public static final String FILENAME_BIOMES = "metadump-biomes-%s.json";
    public static final String FILENAME_BLOCKS = "metadump-blocks-%s-%s.json";
    public static final String FILENAME_VERSION = "metadump-version-%s.json";
    private static final String JSON_INDENT = "  ";

    private void dumpBiomes() {
        try {
            JsonWriter writer = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(String.format(FILENAME_BIOMES, "1.8")), "UTF-8"));
            writer.setIndent(JSON_INDENT);
            writer.beginObject();
            writer.name("Biomes");
            writer.beginArray();
            for (BiomeGenBase biome : BiomeGenBase.func_150565_n()) {
                if (biome == null) continue;
                writer.beginObject();
                this.writeBiomeProperties(writer, biome);
                writer.endObject();
            }
            writer.endArray();
            writer.endObject();
            writer.close();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void dumpBlocks() {
        try {
            FMLControlledNamespacedRegistry blockRegistry = GameData.getBlockRegistry();
            HashSet<String> mods = new HashSet<String>();
            for (int id = 0; id < 4096; ++id) {
                Block block = (Block)blockRegistry.func_148754_a(id);
                if (block == null) continue;
                String blockName = blockRegistry.func_177774_c((Object)block).toString();
                String modName = blockName.substring(0, blockName.indexOf(":"));
                mods.add(modName);
            }
            for (String modName : mods) {
                String modNameAndVersion = this.getSafeModNameAndVersion(modName);
                JsonWriter writer = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(String.format(FILENAME_BLOCKS, "1.8", modNameAndVersion)), "UTF-8"));
                writer.setIndent(JSON_INDENT);
                writer.beginObject();
                writer.name("Blocks");
                writer.beginArray();
                for (int id = 0; id < 4096; ++id) {
                    String blockName;
                    Block block = (Block)blockRegistry.func_148754_a(id);
                    if (block == null || block.func_149739_a().equals("tile.air") || !(blockName = blockRegistry.func_177774_c((Object)block).toString()).startsWith(modName + ":")) continue;
                    writer.beginObject();
                    writer.name("Id");
                    writer.value((long)id);
                    writer.name("Name");
                    writer.value(blockName);
                    this.writeBlockProperties(writer, block);
                    writer.name("HasSubTypes");
                    Item item = Item.func_150898_a((Block)block);
                    if (item != null && item.func_77614_k()) {
                        writer.value(true);
                        this.writeSubBlocks(writer, block, item);
                    } else {
                        writer.value(false);
                    }
                    writer.endObject();
                }
                writer.endArray();
                writer.endObject();
                writer.close();
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void dumpVersionInfo() {
        try {
            JsonWriter writer = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(String.format(FILENAME_VERSION, "1.8")), "UTF-8"));
            Loader loader = Loader.instance();
            writer.setIndent(JSON_INDENT);
            writer.beginObject();
            writer.name("MCVersionString");
            writer.value(loader.getMCVersionString());
            writer.name("MCPVersionString");
            writer.value(loader.getMCPVersionString());
            writer.name("FMLVersionString");
            writer.value(loader.getFMLVersionString());
            writer.name("ActiveModList");
            this.writeActiveModListArray(writer);
            writer.endObject();
            writer.close();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getSafeModNameAndVersion(String modName) {
        String escapedModName;
        String modNameAndVersion = escapedModName = modName.replaceAll("\\W+", "_");
        if (modName.equals("minecraft")) {
            modNameAndVersion = modNameAndVersion + "-1.8";
        } else {
            for (ModContainer modContainer : Loader.instance().getActiveModList()) {
                if (!modContainer.getModId().toUpperCase().equals(modName.toUpperCase())) continue;
                modNameAndVersion = modNameAndVersion + "-" + modContainer.getVersion();
                break;
            }
        }
        return modNameAndVersion;
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        this.dumpVersionInfo();
        this.dumpBlocks();
        this.dumpBiomes();
    }

    private void writeActiveModListArray(JsonWriter writer) throws IOException {
        Loader loader = Loader.instance();
        writer.beginArray();
        for (ModContainer modContainer : loader.getActiveModList()) {
            writer.beginObject();
            writer.name("ModId");
            writer.value(modContainer.getModId());
            writer.name("Name");
            writer.value(modContainer.getName());
            writer.name("Version");
            writer.value(modContainer.getVersion());
            writer.name("DisplayVersion");
            writer.value(modContainer.getDisplayVersion());
            writer.name("Source");
            writer.value(modContainer.getSource().getName());
            writer.endObject();
        }
        writer.endArray();
    }

    private void writeBiomeProperties(JsonWriter writer, BiomeGenBase biome) throws IOException {
        writer.name("Id");
        writer.value((long)biome.field_76756_M);
        writer.name("Name");
        writer.value(biome.field_76791_y);
        BiomeDictionary.Type[] types = BiomeDictionary.getTypesForBiome((BiomeGenBase)biome);
        if (types != null) {
            writer.name("Type");
            writer.beginArray();
            for (int i = 0; i < types.length; ++i) {
                writer.value(types[i].toString());
            }
            writer.endArray();
        }
        writer.name("Color");
        writer.value(String.format("#%06X", biome.field_76790_z));
        writer.name("WaterColorMultiplier");
        writer.value(String.format("#%06x", biome.getWaterColorMultiplier()));
        writer.name("EnableSnow");
        writer.value(biome.func_76746_c());
        writer.name("SpawningChance");
        writer.value((double)biome.func_76741_f());
        writer.name("TempCategory");
        writer.value(biome.func_150561_m().toString());
        writer.name("Class");
        this.writeClassArray(writer, biome.getClass(), BiomeGenBase.class);
    }

    private void writeBlockMapColors(JsonWriter writer, Block block) throws IOException {
        int i;
        String[] colors = new String[16];
        boolean isAllEqual = true;
        for (i = 0; i < 16; ++i) {
            IBlockState state = null;
            try {
                state = block.func_176203_a(i);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (state == null) continue;
            colors[i] = String.format("#%06X", block.func_180659_g((IBlockState)state).field_76291_p);
            if (i <= 0 || !isAllEqual || colors[i].equals(colors[0])) continue;
            isAllEqual = false;
        }
        if (isAllEqual) {
            writer.name("MapColor");
            writer.value(colors[0]);
        } else {
            writer.name("MapColors");
            writer.beginArray();
            for (i = 0; i < 16; ++i) {
                writer.value(colors[i]);
            }
            writer.endArray();
        }
    }

    private void writeBlockProperties(JsonWriter writer, Block block) throws IOException {
        writer.name("UnlocalizedName");
        writer.value(StatCollector.func_74838_a((String)block.func_149739_a()));
        writer.name("LocalizedName");
        writer.value(StatCollector.func_74838_a((String)block.func_149732_F()));
        writer.name("CanProvidePower");
        writer.value(block.func_149744_f());
        writer.name("LightOpacity");
        writer.value((long)block.func_149717_k());
        writer.name("LightValue");
        writer.value((long)block.func_149750_m());
        writer.name("IsOpaqueCube");
        writer.value(block.func_149662_c());
        writer.name("IsFullBlock");
        writer.value(block.func_149730_j());
        writer.name("IsFullCube");
        writer.value(block.func_149686_d());
        writer.name("IsNormalCube");
        writer.value(block.func_149721_r());
        writer.name("IsSolidFullCube");
        writer.value(block.func_149637_q());
        writer.name("IsOpaqueCube");
        writer.value(block.func_149662_c());
        writer.name("IsTranslucent");
        writer.value(block.func_149751_l());
        writer.name("IsVisuallyOpaque");
        writer.value(block.func_176214_u());
        writer.name("RenderType");
        writer.value((long)block.func_149645_b());
        writer.name("IsCollidable");
        writer.value(block.func_149703_v());
        writer.name("IsFlowerPot");
        writer.value(block.func_149648_K());
        writer.name("UseNeighborBrightness");
        writer.value(block.func_149710_n());
        writer.name("Material");
        writer.beginObject();
        this.writeMaterialProperties(writer, block.func_149688_o());
        writer.endObject();
        writer.name("Class");
        this.writeClassArray(writer, block.getClass(), Block.class);
        this.writeBlockMapColors(writer, block);
    }

    private void writeClassArray(JsonWriter writer, Class value, Class root) throws IOException {
        writer.beginArray();
        while (value != null && value != root) {
            writer.value(value.getName());
            value = value.getSuperclass();
        }
        writer.endArray();
    }

    private void writeMaterialProperties(JsonWriter writer, Material material) throws IOException {
        writer.name("IsSolid");
        writer.value(material.func_76220_a());
        writer.name("IsLiquid");
        writer.value(material.func_76224_d());
        writer.name("IsOpaque");
        writer.value(material.func_76218_k());
        writer.name("CanBurn");
        writer.value(material.func_76217_h());
    }

    private void writeSubBlocks(JsonWriter writer, Block block, Item item) throws IOException {
        ArrayList list = new ArrayList();
        try {
            item.func_150895_a(item, CreativeTabs.field_78027_g, list);
        }
        catch (Exception e) {
            writer.name("SubBlocksException");
            writer.value(e.toString());
            return;
        }
        writer.name("SubBlocks");
        writer.beginArray();
        for (ItemStack i : list) {
            writer.beginObject();
            writer.name("ItemDamage");
            writer.value((long)i.func_77952_i());
            writer.name("DisplayName");
            writer.value(StatCollector.func_74838_a((String)i.func_82833_r()));
            writer.name("UnlocalizedName");
            writer.value(StatCollector.func_74838_a((String)i.func_77977_a()));
            writer.endObject();
        }
        writer.endArray();
    }
}

