/*
 * Decompiled with CFR 0.152.
 */
package hu.intro.unmined.metadumpmod;

import com.google.gson.stream.JsonWriter;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

@Mod(modid="MetaDump", name="MetaDump", version="1.0.1")
public class MetaDumpMod {
    public static final String MOD_ID = "MetaDump";
    public static final String MOD_NAME = "MetaDump";
    public static final String MOD_VERSION = "1.0.1";
    public static final String FILENAME_BIOMES = "metadump-biomes-%s.json";
    public static final String FILENAME_BLOCKS = "metadump-blocks-%s-%s.json";
    public static final String FILENAME_VERSION = "metadump-version-%s.json";
    private static final String JSON_INDENT = "  ";
    private String MCVersionString = "";

    private void dumpBiomes() {
        try {
            JsonWriter writer = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(String.format(FILENAME_BIOMES, this.MCVersionString)), "UTF-8"));
            writer.setIndent(JSON_INDENT);
            writer.beginObject();
            writer.name("Biomes");
            writer.beginArray();
            for (BiomeGenBase biome : BiomeGenBase.field_76773_a) {
                if (biome == null) continue;
                writer.beginObject();
                this.writeBiomeProperties(writer, biome);
                writer.endObject();
            }
            writer.endArray();
            writer.endObject();
            writer.close();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void dumpBlocks() {
        try {
            HashSet<String> mods = new HashSet<String>();
            mods.add("minecraft");
            for (Block block : Block.field_71973_m) {
                GameRegistry.UniqueIdentifier uid;
                if (block == null || block.field_71990_ca == 0 || (uid = GameRegistry.findUniqueIdentifierFor((Block)block)) == null) continue;
                String modName = uid.modId;
                mods.add(modName);
            }
            for (String modName : mods) {
                String modNameAndVersion = this.getSafeModNameAndVersion(modName);
                JsonWriter writer = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(String.format(FILENAME_BLOCKS, this.MCVersionString, modNameAndVersion)), "UTF-8"));
                writer.setIndent(JSON_INDENT);
                writer.beginObject();
                writer.name("Blocks");
                writer.beginArray();
                for (Block block : Block.field_71973_m) {
                    GameRegistry.UniqueIdentifier blockUID;
                    if (block == null || block.field_71990_ca == 0 || block.func_71917_a().equals("tile.air") || (blockUID = GameRegistry.findUniqueIdentifierFor((Block)block)) == null && modName != "minecraft" || blockUID != null && modName != blockUID.modId) continue;
                    writer.beginObject();
                    writer.name("Id");
                    writer.value((long)block.field_71990_ca);
                    writer.name("Name");
                    if (blockUID == null) {
                        writer.value((long)block.field_71990_ca);
                    } else {
                        writer.value(blockUID.modId + ":" + blockUID.name);
                    }
                    this.writeBlockProperties(writer, block);
                    writer.name("HasSubTypes");
                    Item item = this.getItemFromBlock(block);
                    if (item != null && item.func_77614_k()) {
                        writer.value(true);
                        this.writeSubBlocks(writer, block, item);
                    } else {
                        writer.value(false);
                    }
                    writer.endObject();
                }
                writer.endArray();
                writer.endObject();
                writer.close();
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Item getItemFromBlock(Block block) {
        for (Item item : Item.field_77698_e) {
            if (item == null || item.field_77779_bT != block.field_71990_ca) continue;
            return item;
        }
        return null;
    }

    private void dumpVersionInfo() {
        try {
            JsonWriter writer = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(String.format(FILENAME_VERSION, this.MCVersionString)), "UTF-8"));
            Loader loader = Loader.instance();
            writer.setIndent(JSON_INDENT);
            writer.beginObject();
            writer.name("MCVersionString");
            writer.value(loader.getMCVersionString());
            writer.name("MCPVersionString");
            writer.value(loader.getMCPVersionString());
            writer.name("FMLVersionString");
            writer.value(loader.getFMLVersionString());
            writer.name("ActiveModList");
            this.writeActiveModListArray(writer);
            writer.endObject();
            writer.close();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getSafeModNameAndVersion(String modName) {
        String escapedModName;
        String modNameAndVersion = escapedModName = modName.replaceAll("\\W+", "_");
        if (modName.equals("minecraft")) {
            modNameAndVersion = modNameAndVersion + "-" + this.MCVersionString;
        } else {
            for (ModContainer modContainer : Loader.instance().getActiveModList()) {
                if (!modContainer.getModId().toUpperCase().equals(modName.toUpperCase())) continue;
                modNameAndVersion = modNameAndVersion + "-" + modContainer.getVersion();
                break;
            }
        }
        return modNameAndVersion;
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        this.MCVersionString = Loader.instance().getMCVersionString().replace("Minecraft ", "");
        this.dumpVersionInfo();
        this.dumpBlocks();
        this.dumpBiomes();
    }

    private void writeActiveModListArray(JsonWriter writer) throws IOException {
        Loader loader = Loader.instance();
        writer.beginArray();
        for (ModContainer modContainer : loader.getActiveModList()) {
            writer.beginObject();
            writer.name("ModId");
            writer.value(modContainer.getModId());
            writer.name("Name");
            writer.value(modContainer.getName());
            writer.name("Version");
            writer.value(modContainer.getVersion());
            writer.name("DisplayVersion");
            writer.value(modContainer.getDisplayVersion());
            writer.name("Source");
            writer.value(modContainer.getSource().getName());
            writer.endObject();
        }
        writer.endArray();
    }

    private void writeBiomeProperties(JsonWriter writer, BiomeGenBase biome) throws IOException {
        writer.name("Id");
        writer.value((long)biome.field_76756_M);
        writer.name("Name");
        writer.value(biome.field_76791_y);
        BiomeDictionary.Type[] types = BiomeDictionary.getTypesForBiome((BiomeGenBase)biome);
        if (types != null) {
            writer.name("Type");
            writer.beginArray();
            for (int i = 0; i < types.length; ++i) {
                writer.value(types[i].toString());
            }
            writer.endArray();
        }
        writer.name("Color");
        writer.value(String.format("#%06X", biome.field_76790_z));
        writer.name("WaterColorMultiplier");
        writer.value(String.format("#%06x", biome.getWaterColorMultiplier()));
        writer.name("EnableSnow");
        writer.value(biome.func_76746_c());
        writer.name("SpawningChance");
        writer.value((double)biome.func_76741_f());
        writer.name("Temperature");
        writer.value((double)biome.field_76750_F);
        writer.name("Class");
        this.writeClassArray(writer, biome.getClass(), BiomeGenBase.class);
    }

    private void writeBlockProperties(JsonWriter writer, Block block) throws IOException {
        writer.name("UnlocalizedName");
        writer.value(StatCollector.func_74838_a((String)block.func_71917_a()));
        writer.name("LocalizedName");
        writer.value(StatCollector.func_74838_a((String)block.func_71931_t()));
        writer.name("CanProvidePower");
        writer.value(block.func_71853_i());
        writer.name("IsOpaqueCube");
        writer.value(block.func_71926_d());
        writer.name("IsCollidable");
        writer.value(block.func_71935_l());
        writer.name("IsFlowerPot");
        writer.value(block.func_82505_u_());
        writer.name("Material");
        writer.beginObject();
        this.writeMaterialProperties(writer, block.field_72018_cp);
        writer.endObject();
        writer.name("Class");
        this.writeClassArray(writer, block.getClass(), Block.class);
    }

    private void writeClassArray(JsonWriter writer, Class value, Class root) throws IOException {
        writer.beginArray();
        while (value != null && value != root) {
            writer.value(value.getName());
            value = value.getSuperclass();
        }
        writer.endArray();
    }

    private void writeMaterialProperties(JsonWriter writer, Material material) throws IOException {
        writer.name("IsSolid");
        writer.value(material.func_76220_a());
        writer.name("IsLiquid");
        writer.value(material.func_76224_d());
        writer.name("IsOpaque");
        writer.value(material.func_76218_k());
        writer.name("CanBurn");
        writer.value(material.func_76217_h());
    }

    private void writeSubBlocks(JsonWriter writer, Block block, Item item) throws IOException {
        ArrayList list = new ArrayList();
        try {
            item.func_77633_a(item.field_77779_bT, CreativeTabs.field_78027_g, list);
        }
        catch (Exception e) {
            writer.name("SubBlocksException");
            writer.value(e.toString());
            return;
        }
        writer.name("SubBlocks");
        writer.beginArray();
        for (ItemStack i : list) {
            writer.beginObject();
            writer.name("ItemDamage");
            writer.value((long)i.func_77960_j());
            writer.name("DisplayName");
            writer.value(StatCollector.func_74838_a((String)i.func_82833_r()));
            writer.name("UnlocalizedName");
            writer.value(StatCollector.func_74838_a((String)i.func_77977_a()));
            writer.endObject();
        }
        writer.endArray();
    }
}

